import {push} from 'react-router-redux';
import {updateRetpath} from '@blocks/common/actions';
import {Platforms, ModeToOpenMetrics} from '../nativeMobileApi/constants';

function createActionName(name) {
    return `nativeMobileApi/${name}`;
}

export const NATIVE_MOBILE_API_INCOMING_ACTIONS = {
    UPDATE_SAVED_EXPERIMENTS: createActionName('UPDATE_SAVED_EXPERIMENTS')
};

export const NATIVE_MOBILE_API_OUTGOING_ACTIONS = {
    SET_POPUP_SIZE: createActionName('SET_POPUP_SIZE'),
    READY: createActionName('READY'),
    CLOSE: createActionName('CLOSE'),
    CHOOSE_ACCOUNT: createActionName('CHOOSE_ACCOUNT'),
    AUTH_SUCCEED: createActionName('AUTH_SUCCEED'),
    REQUEST_SWC: createActionName('REQUEST_SWC'),
    START_SOCIAL_AUTH: createActionName('START_SOCIAL_AUTH'),
    START_SAML_SSO_AUTH: createActionName('START_SAML_SSO_AUTH'),
    SHOW_DEBUG_INFO: createActionName('SHOW_DEBUG_INFO'),
    SEND_METRICS: createActionName('SEND_METRICS'),
    GET_SMS: createActionName('GET_SMS'),
    GET_OTP: createActionName('GET_OTP'),
    GET_PHONE_REGION_CODE: createActionName('GET_PHONE_REGION_CODE'),
    REQUEST_SAVED_EXPERIMENTS: createActionName('REQUEST_SAVED_EXPERIMENTS'),
    REQUEST_PHONE_NUMBER_HINT: createActionName('REQUEST_PHONE_NUMBER_HINT'),
    STORE_PHONE_NUMBER: createActionName('STORE_PHONE_NUMBER'),
    STORE_ICLOUD_TOKEN: createActionName('STORE_ICLOUD_TOKEN'),
    GET_CUSTOM_EULA_STRINGS: createActionName('GET_CUSTOM_EULA_STRINGS'),
    BEGIN_CHANGE_PASSWORD_FLOW: createActionName('BEGIN_CHANGE_PASSWORD_FLOW'),
    PRIMARY_ACTION_TRIGGERED: createActionName('PRIMARY_ACTION_TRIGGERED'),
    DELETED_ACCOUNT_AUTH: createActionName('DELETED_ACCOUNT_AUTH')
};

export const REMOVE_PHONE = createActionName('REMOVE_PHONE');
export const UPDATE_EULA_STRINGS = createActionName('UPDATE_EULA_STRINGS');
export const SET_AUTH_BY_SWC = createActionName('SET_AUTH_BY_SWC');
export const SAVE_SUGGESTED_LOGIN_FROM_SWC = createActionName('SAVE_SUGGESTED_LOGIN_FROM_SWC');
export const SET_PRIMARY_ACTION_TRIGGERED_STATUS = createActionName('SET_PRIMARY_ACTION_TRIGGERED_STATUS');

export function submitAuthSucceed(account, password, successCb) {
    return (dispatch, getState) => {
        const state = getState();
        const {settings = {}} = state;
        const {avatar = {}} = settings;
        const {avatar_300} = avatar;

        let avatarUrl;

        if (avatar_300 && account.avatarId) {
            avatarUrl = avatar_300.replace('%avatar_id%', account.avatarId);
        }

        dispatch({
            type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.AUTH_SUCCEED,
            payload: {
                login: account.login,
                password,
                avatarUrl,
                successCb
            }
        });
    };
}

export function setPopupSize(options) {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.SET_POPUP_SIZE,
        payload: {
            options
        }
    };
}

export function onReady(status = 'ok') {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.READY,
        payload: {
            status
        }
    };
}

export function closeAmPopup() {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.CLOSE
    };
}

export function primaryActionTriggered() {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.PRIMARY_ACTION_TRIGGERED
    };
}

export function setPrimaryActionTriggeredStatus(isError) {
    return {
        type: SET_PRIMARY_ACTION_TRIGGERED_STATUS,
        payload: {
            isError
        }
    };
}

export function beginChangePasswordFlow() {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.BEGIN_CHANGE_PASSWORD_FLOW
    };
}

export function chooseAccount(mask) {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.CHOOSE_ACCOUNT,
        payload: {
            mask
        }
    };
}

export function requestNativeSWC() {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.REQUEST_SWC
    };
}

export function onAuthMount() {
    return function(dispatch, getState) {
        const {am = {}} = getState();

        if (am.isAm) {
            dispatch(requestNativeSWC());
        }
    };
}

export function startSocialAuth(provider) {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.START_SOCIAL_AUTH,
        payload: {
            provider
        }
    };
}

export function startSamlSsoAuth(samlSsoUrl) {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.START_SAML_SSO_AUTH,
        payload: {
            samlSsoUrl
        }
    };
}

export function openDebugPage() {
    return function(dispatch, getState) {
        const {am = {}} = getState();

        if (am.isAm && am.debug) {
            dispatch(push(`/am/debug${location.search}`));
        }
    };
}

export function showDebugInfo() {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.SHOW_DEBUG_INFO
    };
}

export function sendAmMetrics(identifier, parameters = {}) {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.SEND_METRICS,
        payload: {
            identifier,
            parameters
        }
    };
}

export function requestSmsCode() {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.GET_SMS
    };
}

export function amRequestSmsCode() {
    return (dispatch, getState) => {
        const {am = {}} = getState();

        if (am.isAm && am.platform === Platforms.ANDROID) {
            dispatch(requestSmsCode());
        }
    };
}

export function requestOTP(message) {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.GET_OTP,
        payload: message
    };
}

export function amRequestOTP({secret, pin}) {
    return (dispatch, getState) => {
        const state = getState();
        const {am = {}, common = {}, auth = {}} = state;

        if (am.isAm && [Platforms.ANDROID, Platforms.IOS].includes(am.platform)) {
            const isTeam = common.isYandexoid || false;
            const uid = am.uid || (auth.processedAccount && auth.processedAccount.uid);

            dispatch(requestOTP({uid, isTeam, pin, secret}));
        }
    };
}

export function getPhoneRegionCode() {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.GET_PHONE_REGION_CODE
    };
}

export function requestSavedExperiments() {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.REQUEST_SAVED_EXPERIMENTS
    };
}

export function updateSavedExperiments(experiments) {
    return {
        type: NATIVE_MOBILE_API_INCOMING_ACTIONS.UPDATE_SAVED_EXPERIMENTS,
        payload: {
            experiments
        }
    };
}

export function amRequestPhoneNumberHint() {
    return (dispatch, getState) => {
        const {am = {}} = getState();

        if (am.isAm) {
            dispatch({
                type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.REQUEST_PHONE_NUMBER_HINT
            });
        }
    };
}

export function amStorePhoneNumber(phoneNumber) {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.STORE_PHONE_NUMBER,
        payload: {
            phoneNumber
        }
    };
}

export function removePhone() {
    return {
        type: REMOVE_PHONE
    };
}

export function amStoreIcloudToken(token) {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.STORE_ICLOUD_TOKEN,
        payload: {
            token
        }
    };
}

export function sendOpenMetrics() {
    return (dispatch, getState) => {
        const {am = {}} = getState();

        if (am.isAm && ModeToOpenMetrics[am.mode]) {
            dispatch(sendAmMetrics(ModeToOpenMetrics[am.mode]));
        }
    };
}

export function amGetCutsomEulaStrings() {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.GET_CUSTOM_EULA_STRINGS
    };
}

export function amUpdateEulaStrings(eulaStrings) {
    return {
        type: UPDATE_EULA_STRINGS,
        payload: {
            eulaStrings
        }
    };
}

export function amSetAnalyticsToRetpath(analyticsFrom, trackId) {
    return (dispatch, getState) => {
        const {am = {}} = getState();

        if (trackId) {
            dispatch(updateRetpath(`${am.finishOkUrl}&from=${analyticsFrom}&track_id=${trackId}&type=am_challenge`));
            return;
        }

        dispatch(updateRetpath(`${am.finishOkUrl}&from=${analyticsFrom}`));
    };
}

export function amSetAuthBySWC(isAuthBySWC) {
    return {
        type: SET_AUTH_BY_SWC,
        payload: {
            isAuthBySWC
        }
    };
}

export function saveSuggestedLoginFromSWC(login) {
    return {
        type: SAVE_SUGGESTED_LOGIN_FROM_SWC,
        payload: {
            login
        }
    };
}

export function amDeletedAccountAuth() {
    return {
        type: NATIVE_MOBILE_API_OUTGOING_ACTIONS.DELETED_ACCOUNT_AUTH
    };
}
