import {updateMagicTokensSuccess} from './';
import api from '../../api';

export default function reAuthPasswordSubmit() {
    return function(dispatch, getState) {
        const {
            common: {csrf, retpath}
        } = getState();

        const params = {
            csrf_token: csrf
        };

        if (retpath) {
            params.retpath = retpath;
        }

        api.request('reAuthPasswordSubmit', params).done((response) => {
            const {track_id: trackId, csrf_token: csrf} = response;

            dispatch(updateMagicTokensSuccess(trackId, csrf));
        });
    };
}
