import restoreStateAndRedirect from './restoreStateAndRedirect';
import redirectToRetpath from './redirectToRetpath';
import sendAdditionalDataRequestMetrics from './sendAdditionalDataRequestMetrics';

export default function redirectToPhonesPage() {
    return (dispatch, getState) => {
        const {
            settings: {host},
            common: {retpath}
        } = getState();

        let url = `${host}/profile/phones`;

        dispatch(
            sendAdditionalDataRequestMetrics(
                'redirect_to_phones_page',
                'Показ превращения телефона в защищенный',
                'Изменить'
            )
        );

        if (retpath) {
            url += `?retpath=${encodeURIComponent(retpath)}`;
            window.open(url);
            dispatch(redirectToRetpath());
            return;
        }

        dispatch(restoreStateAndRedirect(url));
    };
}
