import formatRegistrationUrl from '../utils/formatRegistrationUrl';
import metrics from '../../metrics';
import {PREREGISTER_PAGE, PREREGISTER_LITE, PREREGISTER_SIMPLE} from '../metrics_constants';

export default function redirectToRegistration() {
    return (dispatch, getState) => {
        const {
            auth: {
                form: {
                    registrationLogin: login,
                    registrationType: type,
                    registrationPhoneNumber: phone,
                    registrationCountry: country
                }
            },
            common: {
                registration_url_with_params: registrationUrl,
                lite_registration_url_with_params: liteRegistrationUrl
            }
        } = getState();
        const isPortalRegistration = type === 'portal';
        const baseUrl = isPortalRegistration ? registrationUrl : liteRegistrationUrl;

        metrics.send([PREREGISTER_PAGE, isPortalRegistration ? PREREGISTER_SIMPLE : PREREGISTER_LITE]);

        window.location.href = formatRegistrationUrl(baseUrl, login, phone, country);
    };
}
