import {startSamlSsoAuth} from '@blocks/authv2/actions/nativeMobileApi';
import metrics from '../../metrics';
import {redirectToLocalUrl} from '../../utils';
import {SAML_REDIRECT} from '../metrics_constants';

export function redirectToSAML({samlSsoUrl}) {
    return (dispatch, getState) => {
        const {am = {}} = getState();

        metrics.send([SAML_REDIRECT, samlSsoUrl]);

        if (am.isAm) {
            return dispatch(startSamlSsoAuth(samlSsoUrl));
        }

        redirectToLocalUrl({
            pathname: samlSsoUrl
        });
    };
}
