import api from '../../../api';
import errors from '../../errors';
import {setErrors} from './';
import switchToModeRegisterLiteName from '../switchToModeRegisterLiteName';
import {domikIsLoading} from '../';

import metrics from '../../../metrics';
import {REGISTER_LITE_CODE_PAGE_SHOW_ERROR, REGISTER_LITE_CODE_PAGE_SUCCESS} from '../../metrics_constants';

export default function checkConfirmationCode() {
    return (dispatch, getState) => {
        const {
            common: {csrf},
            registerLite: {confirmationCode, track_id}
        } = getState();

        dispatch(domikIsLoading(true));
        api.request('registration-code.confirm', {
            csrf_token: csrf,
            track_id,
            key: confirmationCode.trim()
        })
            .done((response = {}) => {
                if (response.status === 'ok') {
                    dispatch(switchToModeRegisterLiteName());
                    metrics.send([REGISTER_LITE_CODE_PAGE_SUCCESS]);
                } else {
                    dispatch(setErrors({confirmationCode: errors.internal}));
                }
            })
            .fail((error) => {
                const errorCode = Array.isArray(error.error) ? error.error[0] : 'internal';

                dispatch(setErrors({confirmationCode: errors[errorCode] ? errors[errorCode] : errors.internal}));
                metrics.send([REGISTER_LITE_CODE_PAGE_SHOW_ERROR]);
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
