import api from '../../../api';
import errors from '../../errors';
import {setLiteRegisterTrackId, setErrors} from './';
import sendConfirmationCode from './sendConfirmationCode';

export default function getRegistrationTrack() {
    return (dispatch, getState) => {
        const {
            common: {csrf}
        } = getState();

        api.request('auth/register_lite/get_track', {csrf_token: csrf})
            .done((result = {}) => {
                if (result.track_id) {
                    dispatch(setLiteRegisterTrackId(result.track_id));
                    dispatch(sendConfirmationCode());
                } else {
                    dispatch(setErrors({confirmationCode: errors.internal}));
                }
            })
            .fail(() => {
                dispatch(setErrors({confirmationCode: errors.internal}));
            });
    };
}
