export const SWITCH_TO_MODE_REGISTER_LITE = 'SWITCH_TO_MODE_REGISTER_LITE';
export const SWITCH_TO_MODE_REGISTER_LITE_FORM = 'SWITCH_TO_MODE_REGISTER_LITE_FORM';
export const SWITCH_TO_MODE_REGISTER_LITE_NAME = 'SWITCH_TO_MODE_REGISTER_LITE_NAME';
export const SWITCH_TO_MODE_REGISTER_LITE_EULA = 'SWITCH_TO_MODE_REGISTER_LITE_EULA';
export const LITE_REGISTER_SET_TRACK_ID = 'LITE_REGISTER_SET_TRACK_ID';
export const LITE_REGISTER_CHANGE_FIRST_NAME = 'LITE_REGISTER_CHANGE_FIRST_NAME';
export const LITE_REGISTER_CHANGE_LAST_NAME = 'LITE_REGISTER_CHANGE_LAST_NAME';
export const LITE_REGISTER_CHANGE_CONFIRMATION_CODE = 'LITE_REGISTER_CHANGE_CONFIRMATION_CODE';
export const LITE_REGISTER_SET_ERRORS = 'LITE_REGISTER_SET_ERRORS';
export const LITE_REGISTER_CHANGE_PASSWORD = 'LITE_REGISTER_CHANGE_PASSWORD';
export const LITE_REGISTER_CHANGE_PASSWORD_CONFIRM = 'LITE_REGISTER_CHANGE_PASSWORD_CONFIRM';
export const LITE_REGISTER_LOGIN_REQUIRED = 'LITE_REGISTER_LOGIN_REQUIRED';
export const LITE_REGISTER_CHANGE_LOGIN = 'LITE_REGISTER_CHANGE_LOGIN';
export const LITE_REGISTER_PASSWORD_WARNING = 'LITE_REGISTER_PASSWORD_WARNING';
export const LITE_REGISTER_PASSWORD_ERROR_DESCR = 'LITE_REGISTER_PASSWORD_ERROR_DESCR';
export const LITE_REGISTER_SET_PASSWORD_VALID = 'LITE_REGISTER_SET_PASSWORD_VALID';

export function setLiteRegisterTrackId(trackId) {
    return {
        type: LITE_REGISTER_SET_TRACK_ID,
        track_id: trackId
    };
}

export function changeFirstName(firstname) {
    return {
        type: LITE_REGISTER_CHANGE_FIRST_NAME,
        firstname
    };
}

export function changeLastName(lastname) {
    return {
        type: LITE_REGISTER_CHANGE_LAST_NAME,
        lastname
    };
}

export function changePassword(password) {
    return {
        type: LITE_REGISTER_CHANGE_PASSWORD,
        password
    };
}

export function changePasswordConfirm(passwordConfirm) {
    return {
        type: LITE_REGISTER_CHANGE_PASSWORD_CONFIRM,
        passwordConfirm
    };
}

export function changeConfirmationCode(confirmationCode) {
    return {
        type: LITE_REGISTER_CHANGE_CONFIRMATION_CODE,
        confirmationCode
    };
}

export function setErrors(errors) {
    return {
        type: LITE_REGISTER_SET_ERRORS,
        errors
    };
}

export function setPasswordWarning(warning) {
    return {
        type: LITE_REGISTER_PASSWORD_WARNING,
        warning
    };
}

export function setPasswordValidity(isValid) {
    return {
        type: LITE_REGISTER_SET_PASSWORD_VALID,
        isValid
    };
}

export function setPasswordErrorDescription(text) {
    return {
        type: LITE_REGISTER_PASSWORD_ERROR_DESCR,
        text
    };
}

export function setStatusLoginRequired(status) {
    return {
        type: LITE_REGISTER_LOGIN_REQUIRED,
        status
    };
}

export function changeLogin(login) {
    return {
        type: LITE_REGISTER_CHANGE_LOGIN,
        login
    };
}
