import api from '../../../api';
import errors from '../../errors';
import {setErrors} from './';
import {domikIsLoading} from '../';

import metrics from '../../../metrics';
import {REGISTER_LITE_SUCCESS, REGISTER_LITE_ERROR} from '../../metrics_constants';
import {amSetAnalyticsToRetpath} from '@blocks/authv2/actions/nativeMobileApi';
import {getRedirectUrl} from '@blocks/selectors';

export default function registerLiteAccount() {
    return (dispatch, getState) => {
        const {
            common: {csrf, origin},
            settings: {language},
            auth: {
                form: {login}
            },
            form: {keepUnsubscribedValue},
            registerLite: {track_id, password, firstname, lastname},
            am: {isAm = false} = {}
        } = getState();
        const data = {
            csrf_token: csrf,
            login,
            language,
            track_id,
            password,
            eula_accepted: 'on'
        };

        if (firstname && lastname) {
            data.lastname = lastname;
            data.firstname = firstname;
        }

        if (keepUnsubscribedValue) {
            data.keepUnsubscribedValue = keepUnsubscribedValue;
        }

        if (origin) {
            data.origin = origin;
        }

        if (isAm) {
            dispatch(amSetAnalyticsToRetpath('magic_link_reg'));
        }

        dispatch(domikIsLoading(true));

        api.request('registration-lite-experiment.commit', data)
            .then((response = {}) => {
                if (response.status === 'ok') {
                    metrics.send([REGISTER_LITE_SUCCESS]);
                    location.href = getRedirectUrl(getState());
                } else {
                    dispatch(setErrors({password: errors.internal}));
                }
            })
            .fail((error = {}) => {
                const errorCode = Array.isArray(error.error) ? error.error[0] : 'internal';

                metrics.send([REGISTER_LITE_ERROR]);
                dispatch(domikIsLoading(false));
                dispatch(setErrors({password: errors[errorCode] ? errors[errorCode] : errors.internal}));
            });
    };
}
