import api from '../../../api';
import {setErrors, setStatusLoginRequired} from './';
import errors from '../../errors';
import switchToModePreregister from '../switchToModePreRegister';
import {domikIsLoading} from '../';

export default function sendConfirmationCode() {
    return (dispatch, getState) => {
        const {
            common: {csrf},
            settings: {language},
            auth: {form, process_uuid},
            registerLite: {track_id}
        } = getState();
        const params = {
            track_id,
            csrf_token: csrf,
            language,
            login: form.login,
            process_uuid
        };

        dispatch(domikIsLoading(true));
        return api
            .request('registration-lite.submit', params)
            .fail((error) => {
                const errorCode = Array.isArray(error.error) ? error.error[0] : 'internal';

                if (errorCode === 'login.empty') {
                    dispatch(setStatusLoginRequired(true));
                    dispatch(switchToModePreregister());
                    return;
                }

                dispatch(
                    setErrors({
                        confirmationCode: errors[errorCode] ? errors[errorCode] : errors.internal,
                        code: errorCode
                    })
                );
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
