import api from '../../../api';
import errors from '../../errors';
import {setErrors} from './';
import {domikIsLoading} from '../../actions';
import switchToModeRegisterLiteForm from '../switchToModeRegisterLiteForm';
import metrics from '../../../metrics';
import {REGISTER_LITE_NAME_SHOW_ERROR, REGISTER_LITE_NAME_SUCCESS} from '../../metrics_constants';

const fieldsErrors = {
    firstname: {
        missingvalue: i18n('_AUTH_.firstname_errors_missingvalue'),
        toolong: i18n('_AUTH_.firstname_errors_toolong'),
        invalid: i18n('_AUTH_.NewRegNotes.noiname'),
        'firstname.invalid': i18n('_AUTH_.NewRegNotes.noiname'),
        'firstname.long': i18n('_AUTH_.firstname_errors_toolong')
    },
    lastname: {
        missingvalue: i18n('_AUTH_.lastname_errors_missingvalue'),
        toolong: i18n('_AUTH_.lastname_errors_toolong'),
        invalid: i18n('_AUTH_.NewRegNotes.nofname'),
        'lastname.invalid': i18n('_AUTH_.NewRegNotes.nofname'),
        'lastname.long': i18n('_AUTH_.lastname_errors_toolong')
    }
};

export default function validateName() {
    return (dispatch, getState) => {
        const {
            common: {csrf},
            registerLite: {track_id: trackId, firstname, lastname}
        } = getState();
        const params = {
            track_id: trackId,
            csrf_token: csrf,
            firstname,
            lastname
        };
        const setEmptyError = (field) => dispatch(setErrors({[field]: fieldsErrors[field].missingvalue}));

        if (!firstname.trim()) {
            setEmptyError('firstname');
            return;
        }

        if (!lastname.trim()) {
            setEmptyError('lastname');
            return;
        }

        api.request('auth/register_lite/validate_name', params)
            .then((response = {}) => {
                if (response.status === 'ok') {
                    dispatch(switchToModeRegisterLiteForm());
                    metrics.send([REGISTER_LITE_NAME_SUCCESS]);
                    return;
                }
                dispatch(setErrors({firstname: errors.internal}));
            })
            .fail((error) => {
                const errorCode = Array.isArray(error.error) ? error.error[0] : 'internal';
                const errorField = error.field || 'firstname';

                dispatch(setErrors({[errorField]: fieldsErrors[errorField][errorCode] || errors.internal}));
                metrics.send([REGISTER_LITE_NAME_SHOW_ERROR]);
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
