import api from '@blocks/api';
import {errorsTxt} from '@blocks/registration/errors';
import {setErrors, setPasswordWarning, setPasswordErrorDescription, setPasswordValidity} from './';
import metrics from '@blocks/metrics';
import {REGISTER_LITE_CODE_PASSWORD_SHOW_ERROR, REGISTER_LITE_PASSWORD_PAGE_SUCCESS} from '../../metrics_constants';

export default function validatePassword() {
    return (dispatch, getState) => {
        const {
            common: {csrf},
            registerLite: {track_id: trackId, password = ''},
            auth: {form}
        } = getState();
        const {login} = form;
        const passwordErrorsTxt = errorsTxt.password;

        if (!password.trim()) {
            dispatch(setPasswordWarning(''));
            dispatch(setPasswordErrorDescription(''));
            dispatch(setErrors({password: passwordErrorsTxt.errors.missingvalue}));
            return;
        }

        api.request('password', {csrf_token: csrf, track_id: trackId, password, login})
            .then((response = {}) => {
                const errorCode =
                    Array.isArray(response.validation_errors) && (response.validation_errors[0] || {}).code;
                const warningCode =
                    Array.isArray(response.validation_warnings) && (response.validation_warnings[0] || {}).code;

                dispatch(setPasswordWarning(''));
                dispatch(setPasswordErrorDescription(''));
                dispatch(setErrors({password: ''}));
                metrics.send([REGISTER_LITE_PASSWORD_PAGE_SUCCESS]);

                if (errorCode) {
                    dispatch(setErrors({password: passwordErrorsTxt.errors[errorCode]}));
                    dispatch(setPasswordErrorDescription(passwordErrorsTxt.descriptions[errorCode]));
                    metrics.send([REGISTER_LITE_CODE_PASSWORD_SHOW_ERROR]);
                    dispatch(setPasswordValidity(false));
                    return;
                }

                if (warningCode) {
                    dispatch(setPasswordWarning(passwordErrorsTxt.errors[`warning.${warningCode}`]));
                    dispatch(setPasswordErrorDescription(passwordErrorsTxt.descriptions[`warning.${warningCode}`]));
                }

                dispatch(setPasswordValidity(true));
            })
            .fail((error = {}) => {
                const errorCode = Array.isArray(error.errors) && (error.errors[0] || {}).code;

                dispatch(
                    setErrors({
                        password: passwordErrorsTxt.errors[errorCode] || errorsTxt.global.errors.smthWrong
                    })
                );
                metrics.send([REGISTER_LITE_CODE_PASSWORD_SHOW_ERROR]);
            });
    };
}
