import {
    updatePhoneValuesToDefaults,
    updatePhoneStatesToDefaults,
    changePhoneConfirmationType,
    validatePhoneForCall,
    setCallConfirmationTimer,
    updateErrorsValid
} from '@blocks/actions/form';

export const clearPhoneData = () => (dispatch, getState) => {
    const {
        form: {validation, isPhoneCallConfirmationAvailable}
    } = getState();

    dispatch(updatePhoneValuesToDefaults());
    dispatch(updatePhoneStatesToDefaults());
    dispatch(updateErrorsValid('phoneCode'));
    dispatch(updateErrorsValid('phone'));

    if (isPhoneCallConfirmationAvailable) {
        dispatch(changePhoneConfirmationType('sms'));
        dispatch(validatePhoneForCall(false));
    }

    if (validation.callConfirmationTimer) {
        clearTimeout(validation.callConfirmationTimer);
        dispatch(setCallConfirmationTimer(null));
    }
};
