import {updateQuestionValues, updateQuestionStates, updateQuestionCustomState} from '@blocks/actions/form';

export function hintQuestionSelectAction(selectVal) {
    return (dispatch, getState) => {
        const {
            form: {humanConfirmation}
        } = getState();
        const selected = humanConfirmation.questionList.find((question) => question.val === selectVal);
        const questionData = {
            hint_question_id: selected.val,
            hint_question: selected.text
        };

        dispatch(updateQuestionValues(questionData));
        dispatch(updateQuestionStates({status: 'valid'}));

        if (selected.val !== '99') {
            dispatch(updateQuestionCustomState({status: 'valid'}));
        } else {
            dispatch(updateQuestionCustomState({status: ''}));
        }
    };
}
