import {moveNextStep} from '@blocks/AuthRegComplete/actions';
import {isAuthComplete} from '@blocks/selectors';
import {getAuthRegCompleteConfig, getCurrentStep} from '@blocks/AuthRegComplete/logic';
import {changeStep, changeProcess} from '@blocks/UserEntryFlow/actions';
import {ENTRY_REGISTER_NO_PHONE_PROCESS} from '@blocks/UserEntryFlow/processes';
import {STEPS} from '@blocks/UserEntryFlow/steps';
import {toggleHumanConfirmation} from './toggleHumanConfirmation';

export function noPhoneAction() {
    return (dispatch, getState) => {
        const state = getState();

        if (isAuthComplete(state)) {
            const currentStep = getCurrentStep(state);
            const authRegCompleteConfig = getAuthRegCompleteConfig(state);
            const currentStepConfig = authRegCompleteConfig[currentStep];
            const nextStep = currentStepConfig.next && currentStepConfig.next(state, 'noPhone');

            dispatch(moveNextStep(currentStep, nextStep));
        } else {
            dispatch(toggleHumanConfirmation('captcha'));

            dispatch(changeProcess(ENTRY_REGISTER_NO_PHONE_PROCESS));
            dispatch(changeStep(STEPS.SQ_SA));
        }
    };
}
