import {updateValidationMethod} from '@blocks/actions/form';
import metrics from '@blocks/metrics';
import {clearPhoneData} from './clearPhoneData';

export const toggleHumanConfirmation = (validationMethod) => (dispatch, getState) => {
    const {
        form: {validation}
    } = getState();

    if (validationMethod === 'captcha' && validationMethod !== validation.method) {
        dispatch(updateValidationMethod('captcha'));
        dispatch(clearPhoneData());
        metrics.send(['Переключение способа валидации пользователя', 'Регистрация с КВ-КО']);
    } else if (validationMethod === 'phone' && validationMethod !== validation.method) {
        dispatch(updateValidationMethod('phone'));
        metrics.send(['Переключение способа валидации пользователя', 'Регистрация с номером телефона']);
    }
};
