import api from '../../api';
import {changePagePopupType, changePagePopupVisibility, domikIsLoading} from './';
import redirectToRetpath from './redirectToRetpath';
import {setErrors, clearErrors, sentEmailConfirmationCodeSuccess} from './additionalDataRequestActions';
import redirectToPasswordRequest from './redirectToPasswordRequest';
import sendAdditionalDataRequestMetrics from './sendAdditionalDataRequestMetrics';

export default function requestEmailConfirmationCode(email) {
    return (dispatch, getState) => {
        if (!email || !email.trim()) {
            dispatch(setErrors(['email.empty']));
            dispatch(domikIsLoading(false));
            return;
        }

        const {
            additionalDataRequest: {track_id: trackId},
            auth: {processedAccount, defaultAccount},
            common: {profile_url: profileUrl, csrf}
        } = getState();

        const account = processedAccount ? processedAccount : defaultAccount;

        const params = {
            email,
            track_id: trackId,
            csrf_token: csrf,
            validator_ui_url: profileUrl,
            retpath: profileUrl,
            code_only: 'yes',
            uid: account ? account.uid : ''
        };

        dispatch(clearErrors());

        api.request('email/send_confirmation_email_v2', params)
            .done(() => {
                dispatch(
                    sendAdditionalDataRequestMetrics(
                        'request_email_confirmation_code',
                        'Показ привязки емейла',
                        'Отправка кода'
                    )
                );
                dispatch(sentEmailConfirmationCodeSuccess());
                dispatch(domikIsLoading(false));
                dispatch(changePagePopupVisibility(true));
                dispatch(changePagePopupType('emailConfirmation'));
            })
            .fail((error) => {
                const errorsCount = error.errors.length;

                for (let errorIndex = 0; errorIndex < errorsCount; errorIndex++) {
                    const apiError = error.errors[errorIndex];

                    if (apiError === 'password.required') {
                        dispatch(redirectToPasswordRequest());
                        return;
                    }

                    if (apiError === 'email.already_confirmed') {
                        dispatch(redirectToRetpath());
                        return;
                    }
                }

                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
