import api from '../../api';
import {domikIsLoading, changePagePopupVisibility, changePagePopupType} from './';
import {setErrors, clearErrors, sentPhoneConfirmationCodeSuccess} from './additionalDataRequestActions';
import redirectToRetpath from './redirectToRetpath';
import redirectToPasswordRequest from './redirectToPasswordRequest';
import sendAdditionalDataRequestMetrics from './sendAdditionalDataRequestMetrics';
import {isAndroidAm} from '@blocks/selectors';

export default function requestPhoneConfirmationCode(number) {
    return (dispatch, getState) => {
        if (!number || !number.trim()) {
            dispatch(setErrors(['number.empty']));
            dispatch(domikIsLoading(false));
            return;
        }
        const state = getState();
        const {
            additionalDataRequest: {track_id: trackId, action},
            settings: {language},
            common: {csrf}
        } = state;
        const params = {
            number,
            track_id: trackId,
            csrf_token: csrf,
            display_language: language
        };

        if (!isAndroidAm(state)) {
            params.isCodeWithFormat = true;
        }

        dispatch(clearErrors());

        api.request('phone/confirm_and_bind_secure/submit_v2', params)
            .done((response) => {
                dispatch(
                    sendAdditionalDataRequestMetrics(
                        'request_phone_confirmation_code',
                        action === 'secure' ? 'Показ превращения телефона в защищенный' : 'Показ привязки телефона',
                        'Отправка кода'
                    )
                );
                dispatch(sentPhoneConfirmationCodeSuccess(response));
                dispatch(domikIsLoading(false));
                dispatch(changePagePopupVisibility(true));
                dispatch(changePagePopupType('additionalDataRequestPhoneConfirmation'));
            })
            .fail((error) => {
                const errorsCount = error.errors.length;

                for (let errorIndex = 0; errorIndex < errorsCount; errorIndex++) {
                    const apiError = error.errors[errorIndex];

                    if (apiError === 'password.required') {
                        dispatch(redirectToPasswordRequest());
                        return;
                    }

                    if (apiError === 'phone.confirmed' || apiError === 'phone_secure.bound_and_confirmed') {
                        dispatch(redirectToRetpath());
                        return;
                    }
                }

                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
