import api from '../../../api';
import {clearErrors, setSuggestedAccounts, setErrors} from './';
import switchToModeRestoreLoginResult from '../switchToModeRestoreLoginResult';
import {handleNamesErrors} from './handleErrors';

export default function checkNames() {
    return (dispatch, getState) => {
        const {
            restoreLogin: {firstName, lastName},
            common: {track_id: trackId}
        } = getState();

        const params = {
            firstname: firstName,
            lastname: lastName,
            track_id: trackId,
            allow_neophonish: true
        };

        dispatch(clearErrors());

        api.request('auth/restore_login/check_names', params)
            .done((res) => {
                dispatch(setSuggestedAccounts(res.accounts || []));
                dispatch(switchToModeRestoreLoginResult());
            })
            .fail((err) => {
                if (err.errors.indexOf('compare.not_matched') > -1) {
                    dispatch(setSuggestedAccounts([]));
                    dispatch(switchToModeRestoreLoginResult());
                    return;
                }

                dispatch(setErrors(handleNamesErrors(err.errors)));
            });
    };
}
