import api from '../../../api';
import {changePhoneOverheatStatus, clearErrors, setErrors} from './';
import switchToModeRestoreLoginProcess from '../switchToModeRestoreLoginProcess';
import {changePagePopupType, changePagePopupVisibility} from '../';
import metrics from '../../../metrics';
import {
    RESTORE_LOGIN_ENTER_PHONE_CODE_SUCCESS,
    RESTORE_LOGIN_ENTER_PHONE_CODE_FAIL,
    RESTORE_LOGIN_PAGE,
    RESTORE_LOGIN_CONFIRM_PHONE_WITH_CALL,
    RESTORE_LOGIN_CONFIRM_PHONE_WITH_FLASH_CALL,
    RESTORE_LOGIN_CONFIRM_PHONE_WITH_SMS,
    RESTORE_LOGIN_FAIL_SMS_CONFIRMATION,
    RESTORE_LOGIN_FAIL_CALL_CONFIRMATION,
    RESTORE_LOGIN_SUCCESS_SMS_CONFIRMATION,
    RESTORE_LOGIN_SUCCESS_CALL_CONFIRMATION
} from '../../metrics_constants';
import {handlePhoneErrors} from './handleErrors';

export default function confirmPhone() {
    return (dispatch, getState) => {
        const {
            common: {track_id: trackId},
            restoreLogin: {confirmationCode}
        } = getState();
        const params = {
            track_id: trackId,
            code: confirmationCode
        };

        dispatch(clearErrors());

        api.request('auth/restore_login/confirm_phone', params)
            .done(() => {
                dispatch(changePagePopupVisibility(false));
                dispatch(changePagePopupType(''));
                dispatch(switchToModeRestoreLoginProcess());
                metrics.send([RESTORE_LOGIN_PAGE, RESTORE_LOGIN_ENTER_PHONE_CODE_SUCCESS]);

                sendMetrics(getState());
            })
            .fail((err) => {
                const errors = err.errors || [];

                if (errors.includes('calls_limit.exceeded')) {
                    dispatch(changePhoneOverheatStatus(true));
                }

                dispatch(setErrors(handlePhoneErrors(errors)));
                metrics.send([RESTORE_LOGIN_PAGE, RESTORE_LOGIN_ENTER_PHONE_CODE_FAIL]);

                sendMetrics(getState(), errors);
            });
    };
}

export function sendMetrics(state, errors) {
    const {
        restoreLogin: {isCallExp, isFlashCallExp, confirmMethod}
    } = state;
    const metricsParams = [RESTORE_LOGIN_PAGE];
    const isSMSConfirmation = confirmMethod === 'by_sms';

    if (isCallExp) {
        metricsParams.push(RESTORE_LOGIN_CONFIRM_PHONE_WITH_CALL);
    } else if (isFlashCallExp) {
        metricsParams.push(RESTORE_LOGIN_CONFIRM_PHONE_WITH_FLASH_CALL);
    } else {
        metricsParams.push(RESTORE_LOGIN_CONFIRM_PHONE_WITH_SMS);
    }

    if (Array.isArray(errors) && errors.length) {
        metricsParams.push(
            isSMSConfirmation ? RESTORE_LOGIN_FAIL_SMS_CONFIRMATION : RESTORE_LOGIN_FAIL_CALL_CONFIRMATION
        );
        metricsParams.push(errors.join(','));
    } else {
        metricsParams.push(
            isSMSConfirmation ? RESTORE_LOGIN_SUCCESS_SMS_CONFIRMATION : RESTORE_LOGIN_SUCCESS_CALL_CONFIRMATION
        );
    }

    metrics.send(metricsParams);
}
