export function handlePhoneErrors(apiErrors) {
    const errors = {};

    if (!Array.isArray(apiErrors)) {
        return errors;
    }

    const codeEmpty = apiErrors.find((err) => err === 'code.empty');
    const codeInvalid = apiErrors.find((err) => err === 'code.invalid');
    const notFound = apiErrors.find((err) => err === 'phone_secure.not_found');
    const rateLimitExceeded = apiErrors.find(
        (err) => err === 'rate.limit_exceeded' || err === 'confirmations_limit.exceeded'
    );
    const callsLimitExceeded = apiErrors.find((err) => err === 'calls_limit.exceeded');
    const internalError = apiErrors.find((err) => err === 'internal');

    if (internalError) {
        errors.code = 'internal';
    }

    if (codeEmpty) {
        errors.code = 'empty';
    }

    if (codeInvalid) {
        errors.code = 'notMatched';
    }

    if (rateLimitExceeded) {
        errors.code = 'rateLimitExceeded';
    }

    if (notFound) {
        errors.phone = 'notFound';
    }

    if (callsLimitExceeded) {
        errors.phone = 'callsLimitExceeded';
        errors.code = 'callsLimitExceeded';
    }

    return errors;
}

export function handleNamesErrors(apiErrors) {
    const errors = {};

    if (!Array.isArray(apiErrors)) {
        return errors;
    }

    const firstNameEmpty = apiErrors.find((err) => err === 'firstname.empty');
    const lastNameEmpty = apiErrors.find((err) => err === 'lastname.empty');
    const notMatched = apiErrors.find((err) => err === 'compare.not_matched');
    const rateLimitExceeded = apiErrors.find((err) => err === 'rate.limit_exceeded');
    const internalError = apiErrors.find((err) => err === 'internal');

    if (internalError) {
        errors.firstName = 'internal';
    }

    if (firstNameEmpty) {
        errors.firstName = 'empty';
    }

    if (lastNameEmpty) {
        errors.lastName = 'empty';
    }

    if (notMatched) {
        errors.firstName = 'notMatched';
    }

    if (rateLimitExceeded) {
        errors.firstName = 'rateLimitExceeded';
        errors.lastName = 'rateLimitExceeded';
    }

    return errors;
}

export function handleCheckPhoneErrors(apiErrors) {
    const errors = {};

    if (!Array.isArray(apiErrors)) {
        return errors;
    }

    const captchaNotMatched = apiErrors.find((err) => err === 'captcha.not_matched');
    const phoneInvalid = apiErrors.find((err) => err === 'phone_number.invalid' || err === 'number.invalid');
    const phoneEmpty = apiErrors.find((err) => err === 'phone.empty' || err === 'phone_number.empty');
    const captchaEmpty = apiErrors.find((err) => err === 'captcha.empty');
    const notFound = apiErrors.find((err) => err === 'phone_secure.not_found');
    const smsLimitExceeded = apiErrors.find((err) => err === 'sms_limit.exceeded');
    const callsLimitExceeded = apiErrors.find((err) => err === 'calls_limit.exceeded');
    const rateLimitExceeded = apiErrors.find((err) => err === 'rate.limit_exceeded');
    const internalError = apiErrors.find((err) => err === 'internal');

    if (internalError) {
        errors.phone = 'internal';
    }

    if (captchaNotMatched) {
        errors.captcha = 'notMatched';
    }

    if (phoneInvalid) {
        errors.phone = 'invalid';
    }

    if (phoneEmpty) {
        errors.phone = 'empty';
    }

    if (captchaEmpty) {
        errors.captcha = 'empty';
    }

    if (notFound) {
        errors.phone = 'notFound';
        errors.code = 'notFound';
    }

    if (smsLimitExceeded) {
        errors.phone = 'smsLimitExceeded';
        errors.code = 'smsLimitExceeded';
    }

    if (callsLimitExceeded) {
        errors.phone = 'callsLimitExceeded';
        errors.code = 'callsLimitExceeded';
    }

    if (rateLimitExceeded) {
        errors.phone = 'rateLimitExceeded';
    }

    return errors;
}
