import api from '../../../api';
import {updateTrack} from '../../../common/actions';
import {domikIsLoading} from '../';
import {clearErrors, setErrors} from './';

export default function submit() {
    return (dispatch) => {
        dispatch(domikIsLoading(true));
        dispatch(clearErrors());

        api.request('auth/restore_login/submit')
            .done((res) => dispatch(updateTrack(res.track_id)))
            .fail(() => dispatch(setErrors(['internal'])))
            .always(() => dispatch(domikIsLoading(false)));
    };
}
