import api from '../../../api';
import goToNextStep from './goToNextStep';
import {updateProcessState, updateCaptchaStatus, updateError} from './';
import processError from './processError';
import {domikIsLoading} from '../';
import {
    RESTORE_PASSWORD,
    RESTORE_PASSWORD_QUESTION_CONFIRM_SUCCESS,
    RESTORE_PASSWORD_QUESTION_CONFIRM_ERROR
} from '../../metrics_constants';
import metrics from '../../../metrics';

export default function checkAnswer(answer) {
    return function(dispatch, getState) {
        const {
            restorePassword: {trackId}
        } = getState();

        if (!answer.trim()) {
            dispatch(
                updateError({
                    code: 'answer.empty',
                    errorText: i18n('_AUTH_.hint_answer_errors_missingvalue')
                })
            );
            return;
        }

        dispatch(domikIsLoading(true));

        api.request('auth/restore_pwd/check_answer', {track_id: trackId, answer})
            .then((response = {}) => {
                const {body = {}} = response;

                if (response.status === 'ok') {
                    dispatch(updateProcessState(body));

                    if (body.isForcePasswordChange || body.isNewMethodBindRequired) {
                        dispatch(goToNextStep('bind-phone'));
                        return;
                    }

                    dispatch(goToNextStep('finish'));
                    metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_QUESTION_CONFIRM_SUCCESS]);
                    return;
                }

                if (response.error && response.error[0] === 'user.not_verified') {
                    dispatch(updateCaptchaStatus(true));
                    dispatch(goToNextStep('captcha'));
                    dispatch(processError('captcha.repeat_required'));
                    return;
                }

                dispatch(processError(response.error));
                metrics.send([RESTORE_PASSWORD, `${RESTORE_PASSWORD_QUESTION_CONFIRM_ERROR}: ${response.error}`]);
            })
            .fail((error) => {
                const errorData = error.error || error;
                const isCaptchaRelatedError = errorData[0] === 'user.not_verified';

                if (isCaptchaRelatedError) {
                    dispatch(updateCaptchaStatus(true));
                    dispatch(goToNextStep('captcha'));
                    dispatch(processError('captcha.repeat_required'));
                    return;
                }

                dispatch(processError(error));
                metrics.send([RESTORE_PASSWORD, `${RESTORE_PASSWORD_QUESTION_CONFIRM_ERROR}: ${errorData}`]);
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
