import api from '../../../api';
import goToNextStep from './goToNextStep';
import processError from './processError';
import {updateError, updateProcessState} from './';
import {domikIsLoading} from '../';
import {
    RESTORE_PASSWORD,
    RESTORE_PASSWORD_EMAL_CODE_SUCCESS,
    RESTORE_PASSWORD_EMAL_CODE_ERROR
} from '../../metrics_constants';
import metrics from '../../../metrics';

export default function checkEmailCode(code) {
    return (dispatch, getState) => {
        const {
            restorePassword: {trackId}
        } = getState();

        if (!code.trim()) {
            dispatch(
                updateError({
                    code: 'code.empty',
                    errorText: i18n('_AUTH_.phones.errors.code.empty')
                })
            );
            return;
        }

        dispatch(domikIsLoading(true));

        api.request('auth/restore_pwd/confirm_email', {track_id: trackId, key: code})
            .done((response = {}) => {
                if (response.status === 'ok') {
                    const {body} = response;
                    const shouldBindRestorationMethod = body.isForcePasswordChange || body.isNewMethodBindRequired;

                    dispatch(updateProcessState(body));

                    if (shouldBindRestorationMethod) {
                        dispatch(goToNextStep('bind-phone'));
                        return;
                    }

                    dispatch(goToNextStep('finish'));
                    metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_EMAL_CODE_SUCCESS]);
                }
            })
            .fail((error = {}) => {
                dispatch(processError(error));
                metrics.send([RESTORE_PASSWORD, `${RESTORE_PASSWORD_EMAL_CODE_ERROR}: ${error.error}`]);
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
