import api from '../../../api';
import getProcessState from './getProcessState';
import processError from './processError';
import goToNextStep from './goToNextStep';
import {updateProcessState} from './index';
import {domikIsLoading} from '../';
import metrics from '../../../metrics';
import {
    RESTORE_PASSWORD,
    RESTORE_PASSWORD_LOGIN_SUCCESS,
    RESTORE_PASSWORD_LOGIN_ERROR,
    RESTORE_PASSWORD_LOGIN_SPECIAL,
    RESTORE_PASSWORD_CAPTCHA_SUCCESS
} from '../../metrics_constants';
import sendApiRequest from '../sendApiRequest';
import multiStepAuthStart from '../multiStepAuthStart';

export default function checkLogin() {
    return function(dispatch, getState) {
        const {
            restorePassword: {trackId},
            auth: {
                form: {login},
                process_uuid
            },
            common: {retpath, profile_url: profileUrl, addUserUrl}
        } = getState();
        const params = {
            track_id: trackId,
            login,
            retpath: retpath || profileUrl,
            process_uuid
        };

        dispatch(domikIsLoading(true));
        metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_CAPTCHA_SUCCESS]);

        api.request('auth/restore_pwd/check_login', params)
            .then((response = {}) => {
                const {body = {}} = response;
                const isSpecialUser = Boolean(body.state);

                if (isSpecialUser) {
                    dispatch(
                        updateProcessState({
                            status: body.state
                        })
                    );
                    dispatch(goToNextStep('notify'));
                    metrics.send([RESTORE_PASSWORD, `${RESTORE_PASSWORD_LOGIN_SPECIAL}: ${body.state}`]);
                    return;
                }

                dispatch(getProcessState());
                metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_LOGIN_SUCCESS]);
            })
            .fail((error = {}) => {
                metrics.send([RESTORE_PASSWORD, `${RESTORE_PASSWORD_LOGIN_ERROR}: ${error.error}`]);

                if (error.error && error.error[0] === 'account.without_password') {
                    dispatch(sendApiRequest(multiStepAuthStart, {login, backPane: addUserUrl}));
                    return;
                }

                if (error.error && error.error[0] === 'account.not_found') {
                    dispatch(goToNextStep());
                }

                dispatch(processError(error.error));
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
