import api from '../../../api';
import processError from './processError';
import getProcessState from './getProcessState';
import {domikIsLoading} from '../';
import {
    RESTORE_PASSWORD,
    RESTORE_PASSWORD_PHONE_CONFIRM_SUCCESS,
    RESTORE_PASSWORD_PHONE_CONFIRM_ERROR
} from '../../metrics_constants';
import metrics from '../../../metrics';

export default function checkPhoneCode(code, isBindingNew, isRestorationBind) {
    return function(dispatch, getState) {
        const {
            common: {csrf, track_id: commonTrackId},
            restorePassword: {trackId, isPhoneValidForCall}
        } = getState();
        const operationType = isBindingNew ? (isRestorationBind ? 'restoreBind' : 'confirmAndBindSecure') : 'restore';
        const params = {
            csrf_token: csrf,
            track_id: isBindingNew && !isRestorationBind ? commonTrackId : trackId,
            mode: operationType,
            code
        };

        dispatch(domikIsLoading(true));

        api.request('phone-confirm-code', params)
            .then((response = {}) => {
                if (response.status === 'ok') {
                    if (isRestorationBind) {
                        dispatch(getProcessState());
                        return;
                    }

                    if (isBindingNew) {
                        location.href = '/profile';
                        return;
                    }

                    dispatch(getProcessState());

                    if (operationType === 'restore') {
                        metrics.send([
                            RESTORE_PASSWORD,
                            `${RESTORE_PASSWORD_PHONE_CONFIRM_SUCCESS}: ${isPhoneValidForCall ? 'звонок' : 'смс'}`
                        ]);
                    }

                    return;
                }

                dispatch(processError('internal'));
            })
            .fail((error = {}) => {
                const {errors} = error;

                dispatch(processError(errors, 'phoneCode'));

                metrics.send([
                    RESTORE_PASSWORD,
                    `${RESTORE_PASSWORD_PHONE_CONFIRM_ERROR}: ${isPhoneValidForCall ? 'звонок' : 'смс'}, ${errors}`
                ]);
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
