import api from '@blocks/api';
import processError from './processError';
import {updateProcessState} from './';
import {updateCSRF} from '@blocks/common/actions';
import goToNextStep from './goToNextStep';
import {domikIsLoading} from '../';
import {deleteTrackId} from '@blocks/actions/tracks';
import {
    RESTORE_PASSWORD,
    RESTORE_PASSWORD_FINISH_SUCCESS,
    RESTORE_PASSWORD_FINISH_ERROR
} from '../../metrics_constants';
import metrics from '@blocks/metrics';

export default function finishRestoraton(isPerformLogout) {
    return function(dispatch, getState) {
        const {
            settings: {language},
            auth: {process_uuid},
            common: {retpath, csrf},
            restorePassword: {trackId, processState = {}, bindHint = {}},
            form: {values}
        } = getState();
        const {
            isForcePasswordChange,
            isNewPhoneBound,
            methodBinded,
            isNewMethodBindRequired,
            isCheckboxForRevokeShown
        } = processState;

        let params = {
            track_id: trackId,
            csrf_token: csrf,
            password: values.password,
            retpath,
            display_language: language,
            process_uuid,
            isCheckboxForRevokeShown
        };

        if (!isPerformLogout) {
            params = Object.assign(params, {
                revoke_app_passwords: false,
                revoke_tokens: false,
                revoke_web_sessions: false
            });
        }

        if (isForcePasswordChange && isNewPhoneBound) {
            params.new_method = 'phone';
        }

        if (isNewMethodBindRequired) {
            params.new_method = methodBinded || 'phone';

            if (methodBinded === 'hint' && bindHint) {
                const {answer, customQuestion, questionId} = bindHint;

                params.answer = answer;
                params.question = customQuestion;

                if (questionId !== '99') {
                    params.question_id = questionId;
                }
            }
        }

        dispatch(domikIsLoading(true));

        api.request('auth/restore_pwd/finish', params)
            .then((response = {}) => {
                if (response.status === 'ok') {
                    dispatch(updateSessionData());
                    metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_FINISH_SUCCESS]);
                    return;
                }

                dispatch(processError(response.error || 'internal'));
            })
            .fail((error) => {
                dispatch(processError(error));
                dispatch(domikIsLoading(false));
                metrics.send([RESTORE_PASSWORD, `${RESTORE_PASSWORD_FINISH_ERROR}: ${error}`]);
            });
    };
}

function updateSessionData() {
    return function(dispatch) {
        api.request('update-csrf')
            .then((response) => {
                if (response.updatedCSRF) {
                    dispatch(updateCSRF(response.updatedCSRF));
                    dispatch(checkSession());
                    return;
                }

                dispatch(processError('internal'));
                dispatch(domikIsLoading(false));
            })
            .fail(() => {
                dispatch(processError('internal'));
                dispatch(domikIsLoading(false));
            });
    };
}

function checkSession() {
    return function(dispatch, getState) {
        const {
            common: {retpath, csrf},
            restorePassword: {
                trackId,
                processState: {methodsToBind = [], methodBinded}
            }
        } = getState();

        api.request('auth/restore_pwd/finish-validate', {
            track_id: trackId,
            csrf_token: csrf,
            retpath
        })
            .then((response = {}) => {
                if (response.status === 'ok') {
                    const isPhoneBind = methodsToBind[0] === 'phone' && !methodBinded;

                    dispatch(deleteTrackId('restore'));

                    if (isPhoneBind) {
                        dispatch(goToNextStep('bind-phone'));
                        return;
                    }

                    dispatch(updateProcessState({isRestorationDone: true}));
                }

                dispatch(processError('internal'));
            })
            .fail(() => dispatch(processError('internal')))
            .always(() => dispatch(domikIsLoading(false)));
    };
}
