import api from '../../../api';
import {setRestorationMethods, updateProcessState} from './';
import setSelectedMethod from './setSelectedMethod';
import processError from './processError';
import goToNextStep from './goToNextStep';

export default function getProcessState() {
    return function(dispatch, getState) {
        const {
            common: {csrf},
            restorePassword: {trackId}
        } = getState();

        api.request('auth/restore_pwd/get_state', {track_id: trackId, csrf_token: csrf})
            .then((response = {}) => {
                dispatch(handleProcessState(response));
            })
            .fail((error) => {
                dispatch(processError(error));
            });
    };
}

function handleProcessState(processState) {
    return function(dispatch, getState) {
        const {
            restorePassword: {
                urls: {restorationForm}
            }
        } = getState();
        const {isConfirmationDone, methods = [], state} = processState;
        const isSemiAutoOnly = methods.length === 1 && methods[0] === 'semi_auto';
        const is2FaUser = methods && methods.includes('phone_and_2fa_factor');
        const isPDDUser = state === 'domain_not_served';
        const isSocialUser = state === 'complete_social';

        if (isSocialUser) {
            location.href = '/profile/upgrade';
            return;
        }

        if (isPDDUser) {
            dispatch(
                updateProcessState({
                    status: state
                })
            );
            dispatch(goToNextStep('notify'));
            return;
        }

        if (is2FaUser) {
            dispatch(setSelectedMethod('phone_and_2fa_factor'));
            return;
        }

        if (isSemiAutoOnly) {
            location.href = restorationForm;
            return;
        }

        if (isConfirmationDone) {
            dispatch(updateProcessState(processState));
            dispatch(goToNextStep('finish'));
            return;
        }

        dispatch(setRestorationMethods(methods));
        dispatch(setSelectedMethod(methods[0]));
    };
}
