import api from '@blocks/api';
import {domikIsLoading} from '@blocks/authv2/actions';
import {setInitialData} from '.';
import {setCaptchaTrack} from '@components/Captcha/actions';
import processError from './processError';

export default function getStartData() {
    return function(dispatch, getState) {
        const {common = {}} = getState();

        dispatch(domikIsLoading(true));

        api.request('auth/restore_pwd/get_track', {csrf_token: common.csrf})
            .then((response = {}) => {
                dispatch(domikIsLoading(false));
                dispatch(setInitialData(response));
                dispatch(setCaptchaTrack(response.trackId));

                api.writeStatbox({
                    track_id: response.trackId,
                    mode: 'restoration_change_password',
                    action: 'opened'
                });
            })
            .fail((error = []) => {
                dispatch(processError(error));
            });
    };
}
