import {push} from 'connected-react-router';
import {setupBackPane} from '../';
import {setupPane} from '../../../common/actions';
import {updateError} from './';

const methodsMap = {
    'email-code': 'emailConfirm',
    'phone-code': 'phoneConfirm',
    semiauto: 'restorationForm',
    method: 'method',
    confirm: 'methodConfirm',
    finish: 'finish',
    'bind-phone': 'bindPhone',
    'bind-hint': 'bindHint',
    'confirm-bind': 'bindPhoneConfirm'
};

export default function goToNextStep(step = 'start') {
    return function(dispatch, getState) {
        const {
            restorePassword: {urls}
        } = getState();
        const actualStep = methodsMap[step] || step;
        const nextStepUrl = urls[actualStep];
        const isEmptyBackPaneRequired = ['finish', 'bind-phone', 'bind-hint', 'confirm-bind'].includes(step);

        window.history.pushState({}, 'restore-password', '/auth/restore/password'); // PASSP-26380
        dispatch(
            updateError({
                code: '',
                errorText: ''
            })
        );
        dispatch(setupBackPane(isEmptyBackPaneRequired ? null : urls.start));
        dispatch(setupPane(nextStepUrl));
        dispatch(push(nextStepUrl));
    };
}
