export const RESTORE_PASSWORD_SET_INITIAL_DATA = 'RESTORE_PASSWORD_SET_INITIAL_DATA';
export const RESTORE_PASSWORD_SET_METHODS = 'RESTORE_PASSWORD_SET_METHODS';
export const RESTORE_PASSWORD_UPDATE_SELECTED_METHOD = 'RESTORE_PASSWORD_UPDATE_SELECTED_METHOD';
export const RESTORE_PASSWORD_UPDATE_ERROR = 'RESTORE_PASSWORD_UPDATE_ERROR';
export const RESTORE_PASSWORD_UPDATE_PROCESS_STATE = 'RESTORE_PASSWORD_UPDATE_PROCESS_STATE';
export const RESTORE_PASSWORD_UPDATE_CAPTCHA_STATUS = 'RESTORE_PASSWORD_UPDATE_CAPTCHA_STATUS';
export const RESTORE_PASSWORD_SET_PHONE_STATUS = 'RESTORE_PASSWORD_SET_PHONE_STATUS';
export const RESTORE_UPDATE_HINT_DATA = 'RESTORE_UPDATE_HINT_DATA';

export function setInitialData(payload) {
    return {
        type: RESTORE_PASSWORD_SET_INITIAL_DATA,
        payload
    };
}

export function setRestorationMethods(methods = []) {
    return {
        type: RESTORE_PASSWORD_SET_METHODS,
        methods
    };
}

export function updateSelectedMethod({method = 'semiauto', methodInfo = {}}) {
    return {
        type: RESTORE_PASSWORD_UPDATE_SELECTED_METHOD,
        method,
        methodInfo
    };
}

export function updateError(error) {
    return {
        type: RESTORE_PASSWORD_UPDATE_ERROR,
        error
    };
}

export function updateProcessState(processState) {
    return {
        type: RESTORE_PASSWORD_UPDATE_PROCESS_STATE,
        processState
    };
}

export function updateCaptchaStatus(isRequired) {
    return {
        type: RESTORE_PASSWORD_UPDATE_CAPTCHA_STATUS,
        isRequired
    };
}

export function updatePhoneInfo({number, isValidForCall}) {
    return {
        type: RESTORE_PASSWORD_SET_PHONE_STATUS,
        number,
        isValidForCall
    };
}

export function updateHintData(payload) {
    return {
        type: RESTORE_UPDATE_HINT_DATA,
        payload
    };
}
