import switchToRestorePassword from '../switchToRestorePassword';
import mainErrors from '../../errors';
import {updateError} from './';
import {updateErrors} from '@blocks/actions/form';
import {getError} from '@blocks/utils';
import {FIELDS_NAMES} from '@components/Field/names';

const errorsToRedirect = [
    'track.invalid_state',
    'unknowntrack',
    'user.not_verified',
    'account.global_logout',
    'method.not_allowed',
    'new_method.empty'
];

const errorTexts = Object.assign({}, mainErrors, {
    'account.disabled': i18n('_AUTH_.account.disabled_detailed'),
    'answer.not_matched': i18n('_AUTH_.restore.hint.error.not_matched'),
    'secret_key.invalid': i18n('_AUTH_.restore.key.error.not_matched'),
    'password.equals_previous': i18n('_AUTH_.password_errors_equals_previous'),
    'password.short': i18n('_AUTH_.password_errors_tooshort'),
    'phone_number.invalid': i18n('_AUTH_.phone_number_errors_badphonenumber'),
    'phone_number.empty': i18n('_AUTH_.phone_number_errors_missingvalue'),
    'phone.not_matched': i18n('_AUTH_.phone-confirm_errors_invalidsecurephone'),
    'email.not_matched': i18n('_AUTH_.restore.email.error.not_matched'),
    'captcha.repeat_required': i18n('_AUTH_.RestorePassword.hint.exceed.error'),
    'password.found_in_history': i18n('_AUTH_.password_errors_foundinhistory'),
    'password.likephonenumber': i18n('_AUTH_.password_errors_likephonenumber'),
    'email.check_limit_exceeded': i18n('_AUTH_.restore.email.error.limit'),
    'phone.check_limit_exceeded': i18n('_AUTH_.error.sms-limit-exceeded'),
    'calls_limit.exceeded': i18n('_AUTH_.phone-calls-limit-exceeded'),
    'phone.compromised': i18n('_AUTH_.phone-confirm_errors_compromised_v2'),
    'account.not_found': i18n('_AUTH_.account_not_found_full')
});

export default function processError(error = 'internal', fieldName = '') {
    return function(dispatch) {
        const errorData = error.error || error.errors || error;
        const errorEntity = Array.isArray(errorData) ? errorData[0] : errorData;
        const errorCode = errorEntity.code || errorEntity;

        if (errorsToRedirect.includes(errorCode)) {
            dispatch(switchToRestorePassword());
            return;
        }

        if (errorCode.indexOf('password') !== -1) {
            return dispatch(
                updateErrors({field: FIELDS_NAMES.PASSWORD, error: getError(FIELDS_NAMES.PASSWORD, errorCode)})
            );
        }

        if (fieldName === FIELDS_NAMES.PHONE_CODE) {
            return dispatch(
                updateErrors({
                    field: FIELDS_NAMES.PHONE_CODE,
                    error: {code: errorCode, text: errorTexts[errorCode] || errorTexts.internal}
                })
            );
        }

        if (fieldName === FIELDS_NAMES.PHONE) {
            dispatch(
                updateErrors({
                    field: FIELDS_NAMES.PHONE,
                    error: getError(FIELDS_NAMES.PHONE, errorCode)
                })
            );
        }

        dispatch(
            updateError({
                code: errorCode,
                errorText: errorTexts[errorCode] || errorTexts.internal
            })
        );
    };
}
