import api from '../../../api';
import goToTheNextStep from './goToNextStep';
import processError from './processError';
import {RESTORE_PASSWORD, RESTORE_PASSWORD_EMAL_SUCCESS, RESTORE_PASSWORD_EMAL_ERROR} from '../../metrics_constants';
import metrics from '../../../metrics';

export default function sendEmail(email, isSimple) {
    return function(dispatch, getState) {
        const {
            settings: {language},
            restorePassword: {trackId}
        } = getState();
        const params = {
            track_id: trackId,
            language,
            email,
            simple: isSimple
        };

        if (!email.trim()) {
            dispatch(processError(['email.empty']));
            return;
        }

        api.request('auth/restore_pwd/send_email', params)
            .then((response = {}) => {
                if (response.error) {
                    dispatch(processError(response.error));
                    return;
                }

                dispatch(goToTheNextStep('confirm'));
                metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_EMAL_SUCCESS]);
            })
            .fail((error) => {
                const errorData = error.error || error;

                dispatch(processError(errorData));
                metrics.send([RESTORE_PASSWORD, `${RESTORE_PASSWORD_EMAL_ERROR}: ${errorData}`]);
            });
    };
}
