import api from '../../../api';
import goToTheNextStep from './goToNextStep';
import processError from './processError';
import {domikIsLoading} from '../';
import {isAndroidAm} from '@blocks/selectors';
import {FIELDS_NAMES} from '@components/Field/names';

export default function sendPhoneCode(number, isCall, confirmationType) {
    return function(dispatch, getState) {
        const state = getState();
        const {
            common: {csrf, track_id: commonTrackId},
            restorePassword: {trackId}
        } = state;
        const isRestoreOperation = confirmationType === 'restore' || confirmationType === 'restoreBind';
        const params = {
            csrf_token: csrf,
            track_id: isRestoreOperation ? trackId : commonTrackId,
            checkCaptcha: false,
            number,
            mode: confirmationType,
            confirmMethod: isCall ? 'by_call' : 'by_sms'
        };

        if (!isAndroidAm(state) && !isCall) {
            params.isCodeWithFormat = true;
        }

        dispatch(domikIsLoading(true));

        api.request('phone-confirm-code-submit', params)
            .done(() => {
                const nextStep = confirmationType === 'restore' ? 'confirm' : 'confirm-bind';

                dispatch(goToTheNextStep(nextStep));
            })
            .fail((error) => {
                dispatch(processError(error, FIELDS_NAMES.PHONE));
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
