import api from '../../../api';
import {updateSelectedMethod} from '.';
import goToNextStep from './goToNextStep';
import processError from './processError';
import {domikIsLoading} from '../';

export default function setSelectedMethod(method) {
    return (dispatch, getState) => {
        const {
            restorePassword: {
                trackId,
                urls: {restoration2FA: restoration2FAUrl}
            }
        } = getState();
        const params = {
            track_id: trackId,
            method
        };

        if (!method) {
            return;
        }

        dispatch(domikIsLoading(true));

        api.request('auth/restore_pwd/select_method', params)
            .then((response = {}) => {
                if (method === 'phone_and_2fa_factor') {
                    location.href = restoration2FAUrl;
                    return;
                }
                dispatch(updateSelectedMethod({method, methodInfo: response.info}));
                dispatch(goToNextStep('method'));
            })
            .fail((error) => {
                dispatch(processError(error));
            })
            .always(() => dispatch(domikIsLoading(false)));
    };
}
