import api from '../../../api';
import {updateError, updateHintData, updateProcessState} from './';
import goToNextStep from './goToNextStep';

export default function validateHintData(data) {
    return (dispatch, getState) => {
        const {
            common: {track_id}
        } = getState();

        api.request('answer', Object.assign({track_id}, data)).done((response = {}) => {
            if (response.validation_errors) {
                const {code, field} = response.validation_errors[0];

                dispatch(updateHintData({errorField: field}));
                dispatch(
                    updateError({
                        code,
                        errorText:
                            field === 'hint_answer'
                                ? i18n('_AUTH_.hint_answer_errors_toolong')
                                : i18n('_AUTH_.hint_question_errors_toolong')
                    })
                );
                return;
            }

            dispatch(updateProcessState({methodBinded: 'hint'}));
            dispatch(goToNextStep('finish'));
        });
    };
}
