import api from '../../../api';
import {errorsTxt} from '../../../registration/errors';
import {updateError} from './';

export default function validatePassword(password = '') {
    return function(dispatch, getState) {
        const {
            common: {csrf},
            restorePassword: {trackId},
            auth: {form}
        } = getState();
        const {login} = form;
        const passwordErrorsTxt = errorsTxt.password;

        if (!password.trim()) {
            return dispatch(
                updateError({
                    code: '',
                    errorText: '',
                    errorDescription: '',
                    warning: ''
                })
            );
        }

        api.request('password', {csrf_token: csrf, track_id: trackId, password, login})
            .then((response = {}) => {
                const errorCode =
                    Array.isArray(response.validation_errors) && (response.validation_errors[0] || {}).code;
                const warningCode =
                    Array.isArray(response.validation_warnings) && (response.validation_warnings[0] || {}).code;

                dispatch(
                    updateError({
                        code: '',
                        errorText: '',
                        errorDescription: '',
                        warning: ''
                    })
                );

                if (errorCode) {
                    dispatch(
                        updateError({
                            code: errorCode,
                            errorText: passwordErrorsTxt.errors[errorCode],
                            errorDescription: passwordErrorsTxt.descriptions[errorCode]
                        })
                    );
                }

                if (warningCode) {
                    dispatch(
                        updateError({
                            warningText: passwordErrorsTxt.errors[`warning.${warningCode}`],
                            warningDescription: passwordErrorsTxt.descriptions[`warning.${warningCode}`]
                        })
                    );
                }
            })
            .fail((error = {}) => {
                const errorCode = Array.isArray(error.errors) && (error.errors[0] || {}).code;

                dispatch(
                    updateError({
                        code: errorCode,
                        errorText: passwordErrorsTxt.errors[errorCode] || errorsTxt.global.errors.smthWrong,
                        errorDescription: passwordErrorsTxt.descriptions[errorCode]
                    })
                );
            });
    };
}
