import api from '../../../api';
import {domikIsLoading} from '../';
import {updatePhoneInfo} from '.';

import processError from './processError';
import sendPhoneCode from './sendPhoneCode';
import {RESTORE_PASSWORD, RESTORE_PASSWORD_PHONE_SUCCESS, RESTORE_PASSWORD_PHONE_ERROR} from '../../metrics_constants';
import metrics from '../../../metrics';
import {hasExp} from '@blocks/selectors';
import {FIELDS_NAMES} from '@components/Field/names';

export default function validatePhone(number, isBindingNew) {
    return function(dispatch, getState) {
        const state = getState();
        const {
            common: {csrf, track_id: commonTrackId},
            restorePassword: {trackId}
        } = state;
        const isRestorePhoneCallExperiment = hasExp(state, 'restore_pwd_calls_on');
        const params = {
            phone_number: number,
            track_id: isBindingNew ? commonTrackId : trackId,
            csrf_token: csrf
        };

        if (isRestorePhoneCallExperiment) {
            params.validate_for_call = true;
        }

        if (!number || !number.toString().trim()) {
            dispatch(processError('phone_number.empty', FIELDS_NAMES.PHONE));
            return;
        }

        dispatch(domikIsLoading(true));

        api.request('auth/validate_phone', params)
            .done((result) => {
                const isValid = result.valid_for_call;

                if (isValid) {
                    dispatch(
                        updatePhoneInfo({
                            isValidForCall: true,
                            number
                        })
                    );
                } else {
                    dispatch(
                        updatePhoneInfo({
                            isValidForCall: false,
                            number
                        })
                    );
                }

                dispatch(sendPhoneCode(number, isValid, isBindingNew ? 'confirmAndBindSecure' : 'restore'));
                metrics.send([RESTORE_PASSWORD, `${RESTORE_PASSWORD_PHONE_SUCCESS}, доступен для звонка: ${isValid}`]);
            })
            .fail((error) => {
                const errorCode = Array.isArray(error.errors) && error.errors[0];

                dispatch(processError(errorCode, FIELDS_NAMES.PHONE));
                metrics.send([RESTORE_PASSWORD, `${RESTORE_PASSWORD_PHONE_ERROR}, ${errorCode}`]);
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
