import {domikIsLoading, redirect} from './';
import {replace} from 'connected-react-router';

export default function restoreStateAndRedirect(url) {
    return function(dispatch, getState) {
        const {
            common: {editUrl},
            auth = {},
            am = {}
        } = getState();
        const {mode} = auth;

        dispatch(domikIsLoading(!am.isAm));

        if (mode !== 'edit' && !am.isAm) {
            dispatch(replace(editUrl));
        }

        redirect(url);
    };
}
