import api from '../../api';
import {
    setAuthMailSent,
    setAuthMailError,
    changePagePopupVisibility,
    changePagePopupType,
    setAuthMailCancelled,
    updateAuthMailStatus,
    domikIsLoading
} from './';

export default function sendAuthLetter() {
    return (dispatch, getState) => {
        const {
            common: {csrf, track_id},
            settings: {language}
        } = getState();

        const params = {
            csrf_token: csrf,
            language,
            track_id
        };

        dispatch(domikIsLoading(true));

        api.request('auth/send_magic_letter', params)
            .done((response = {}) => {
                if (response && response.status === 'ok') {
                    const {code} = response;

                    dispatch(setAuthMailSent(code));
                    dispatch(changePagePopupVisibility(true));
                    dispatch(changePagePopupType('authLetter'));
                    dispatch(setAuthMailCancelled(false));
                    dispatch(updateAuthMailStatus(false));
                } else {
                    dispatch(setAuthMailError('global'));
                }
            })
            .fail((response) => {
                const errorCode = Array.isArray(response.errors) ? response.errors[0] : 'global';

                dispatch(setAuthMailError(errorCode));
            })
            .always(() => {
                dispatch(domikIsLoading(false));
            });
    };
}
