import api from '../../api';
import {setErrors, clearErrors} from './additionalDataRequestActions';
import skipAdditionalData from './skipAdditionalData';
import redirectToPasswordRequest from './redirectToPasswordRequest';
import sendAdditionalDataRequestMetrics from './sendAdditionalDataRequestMetrics';
import {domikIsLoading} from './';

export default function setupConfirmedEmail(email) {
    return (dispatch, getState) => {
        const {
            auth: {processedAccount, defaultAccount},
            common: {csrf}
        } = getState();

        const account = processedAccount ? processedAccount : defaultAccount;

        const params = {
            email,
            csrf_token: csrf,
            is_safe: 'yes',
            uid: account ? account.uid : ''
        };

        dispatch(clearErrors());

        api.request('email/setup_confirmed_v2', params)
            .done(() => {
                dispatch(
                    sendAdditionalDataRequestMetrics(
                        'setup_confirmed_email',
                        'Показ превращения емейла в защищенный',
                        'Превратить'
                    )
                );
                dispatch(skipAdditionalData('no'));
            })
            .fail((error) => {
                if (error.errors.indexOf('password.required') !== -1) {
                    dispatch(redirectToPasswordRequest());
                    return;
                }

                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
