import {push} from 'connected-react-router';
import api from '../../api';
import {updateCSRF} from '../../common/actions';
import {domikIsLoading, showAccountsSuccess, showAccountsFail} from './';

export default function showAccounts(withForceProgress = false) {
    return function(dispatch, getState) {
        const {common: {addUserUrl, origin} = {}} = getState();

        dispatch(domikIsLoading(true));

        api.request('auth/accounts', {origin})
            .done((res) => {
                const csrfToken = res.csrf;

                api.setCsrfToken(csrfToken);
                dispatch(updateCSRF(csrfToken));
                dispatch(showAccountsSuccess(res.accounts));

                const {
                    auth: {mode}
                } = getState();
                const isSuggestAccountPage = mode === 'edit';

                if (isSuggestAccountPage && Object.keys(res.accounts.unitedAccounts).length === 0) {
                    dispatch(push(addUserUrl));
                }

                if (!withForceProgress) {
                    dispatch(domikIsLoading(false));
                }
            })
            .fail((res) => {
                dispatch(showAccountsFail(res.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
