import api from '../../api';
import {updateCSRF} from '../../common/actions';
import {setMagicSuccess, changeProcessedAccount} from '.';

export function showMagicSuccess() {
    return function(dispatch, getState) {
        const {common: {origin} = {}} = getState();

        api.request('auth/accounts', {origin})
            .done((res) => {
                const csrfToken = res.csrf;

                api.setCsrfToken(csrfToken);
                dispatch(updateCSRF(csrfToken));

                if (res.accounts && res.accounts.processedAccount) {
                    dispatch(changeProcessedAccount(res.accounts.processedAccount));
                }
            })
            .always(() => {
                dispatch(setMagicSuccess(true));
            });
    };
}
