import api from '../../api';
import {domikIsLoading} from './';
import redirectToRetpath from './redirectToRetpath';
import {clearErrors} from './additionalDataRequestActions';

export default function skipAdditionalData(userDeclined = 'yes', forcedTrackId) {
    return (dispatch, getState) => {
        const {additionalDataRequest = {}, common = {}} = getState();
        const {csrf} = common;
        const {track_id: trackId} = additionalDataRequest;
        const params = {
            track_id: forcedTrackId || trackId,
            csrf_token: csrf,
            user_declined: userDeclined
        };

        dispatch(clearErrors());

        api.request('auth/additional_data/freeze_v2', params)
            .done(() => {
                dispatch(domikIsLoading(false));
                dispatch(redirectToRetpath());
            })
            .fail(() => {
                dispatch(domikIsLoading(false));
                dispatch(redirectToRetpath());
            });
    };
}
