import broker from '@blocks/authv2/broker';
import {getTrackId} from '@blocks/selectors';
import * as nativeMobileApiActions from '@blocks/authv2/actions/nativeMobileApi';
import {redirect} from '@blocks/authv2/actions';

const startSocialAuth = (params = {}) => {
    return function(dispatch, getState) {
        const state = getState();
        const {provider, scope} = params;

        if (provider === 'autoRu' && state.customs && state.customs.autoRuButton && state.customs.autoRuButton.link) {
            redirect(state.customs.autoRuButton.link);

            return;
        }

        if (state.am && state.am.isAm) {
            dispatch(nativeMobileApiActions.startSocialAuth(provider));

            return;
        }

        const brokerParams = {
            track_id: getTrackId(state, 'register') || getTrackId(state, 'common'),
            provider
        };

        if (state.common.origin) {
            brokerParams.origin = state.common.origin;
        }

        if (scope) {
            brokerParams.scope = scope;
        }

        broker.start(brokerParams);
    };
};

export default startSocialAuth;
