import api from '../../api';
import redirectToRetpath from './redirectToRetpath';
import {domikIsLoading} from './';
import {setErrors, clearErrors} from './additionalDataRequestActions';
import skipAdditionalData from './skipAdditionalData';
import redirectToPasswordRequest from './redirectToPasswordRequest';
import sendAdditionalDataRequestMetrics from './sendAdditionalDataRequestMetrics';

export default function submitEmailConfirmationCode(key) {
    return (dispatch, getState) => {
        if (!key || !key.trim()) {
            dispatch(setErrors(['key.empty']));
            dispatch(domikIsLoading(false));
            return;
        }

        const {
            additionalDataRequest: {track_id: trackId},
            auth: {processedAccount, defaultAccount},
            common: {csrf}
        } = getState();

        const account = processedAccount ? processedAccount : defaultAccount;

        const params = {
            key,
            csrf_token: csrf,
            track_id: trackId,
            uid: account ? account.uid : ''
        };

        dispatch(clearErrors());

        api.request('email/confirm/by_code_v2', params)
            .done(() => {
                dispatch(
                    sendAdditionalDataRequestMetrics(
                        'submit_email_confirmation_code',
                        'Показ привязки емейла',
                        'Успешная привязка'
                    )
                );
                dispatch(skipAdditionalData('no'));
            })
            .fail((error) => {
                const errorsCount = error.errors.length;

                for (let errorIndex = 0; errorIndex < errorsCount; errorIndex++) {
                    const apiError = error.errors[errorIndex];

                    if (apiError === 'password.required') {
                        dispatch(redirectToPasswordRequest());
                        return;
                    }

                    if (apiError === 'email.already_confirmed') {
                        dispatch(redirectToRetpath());
                        return;
                    }
                }

                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
