import api from '../../api';
import {domikIsLoading} from './';
import {setErrors, clearErrors} from './additionalDataRequestActions';
import redirectToRetpath from './redirectToRetpath';
import skipAdditionalData from './skipAdditionalData';
import redirectToPasswordRequest from './redirectToPasswordRequest';
import sendAdditionalDataRequestMetrics from './sendAdditionalDataRequestMetrics';

export default function submitPhoneConfirmationCode(code) {
    return (dispatch, getState) => {
        if (!code || !code.trim()) {
            dispatch(setErrors(['code.empty']));
            dispatch(domikIsLoading(false));
            return;
        }

        const {
            additionalDataRequest: {track_id: trackId},
            common: {csrf}
        } = getState();
        const params = {
            code,
            track_id: trackId,
            csrf_token: csrf
        };

        dispatch(clearErrors());

        api.request('phone/confirm_and_bind_secure/commit_v2', params)
            .done(() => {
                dispatch(
                    sendAdditionalDataRequestMetrics(
                        'submit_phone_confirmation_code',
                        'Показ привязки телефона',
                        'Успешная привязка'
                    )
                );
                dispatch(skipAdditionalData('no'));
            })
            .fail((error) => {
                const errorsCount = error.errors.length;

                for (let errorIndex = 0; errorIndex < errorsCount; errorIndex++) {
                    const apiError = error.errors[errorIndex];

                    if (apiError === 'password.required') {
                        dispatch(redirectToPasswordRequest());
                        return;
                    }

                    if (apiError === 'phone_secure.bound_and_confirmed') {
                        dispatch(redirectToRetpath());
                        return;
                    }
                }

                dispatch(setErrors(error.errors));
                dispatch(domikIsLoading(false));
            });
    };
}
