import {push} from 'connected-react-router';
import {switchToModeAddingAccountSuccess, setupBackPane} from './';

export default function switchToModeAddingAccount() {
    return (dispatch, getState) => {
        const {
            common: {addUserUrl, editUrl},
            auth: {unitedAccounts = {}, mode}
        } = getState();

        if (mode === 'addingAccount') {
            return;
        }

        dispatch(push(addUserUrl));

        if (Object.keys(unitedAccounts).length > 0) {
            dispatch(setupBackPane(editUrl));
        } else {
            dispatch(setupBackPane(null));
        }

        dispatch(switchToModeAddingAccountSuccess());
    };
}
