import {push} from 'connected-react-router';
import {setRegisterMode} from '@blocks/SignUp/actions';
import {setupBackPane, setupPane} from '@blocks/common/actions';
import {setupMode} from '@blocks/authv2/actions';
import {updateValues} from '@blocks/actions/form';
import {MODE_WITH_SUGGEST_TO_RESTORE_BY_PHONE, MODE_NEOPHONISH} from '@blocks/SignUp/modes/constants';
import {getProcessName, isRestoreProcess} from '@blocks/UserEntryFlow/utils';
import {ENTRY_REGISTER_ROUTE} from '@blocks/UserEntryFlow/processes';
import {isNeoPhonishRegisterAvailable} from '@blocks/selectors';

const switchToModeRegister = () => (dispatch, getState) => {
    const state = getState();
    const process = getProcessName(state);
    const {
        router: {
            location: {search}
        },
        common: {pane},
        auth: {form = {}}
    } = state;
    const {registrationLogin} = form;
    const route = `${ENTRY_REGISTER_ROUTE}${search}`;
    const isNeoPhonishRegister = isNeoPhonishRegisterAvailable(state);

    if (registrationLogin && !isRestoreProcess(process)) {
        dispatch(updateValues({field: 'login', value: registrationLogin}));
    }

    dispatch(setRegisterMode(isNeoPhonishRegister ? MODE_NEOPHONISH : MODE_WITH_SUGGEST_TO_RESTORE_BY_PHONE));
    dispatch(setupBackPane(pane));
    dispatch(setupPane(route));
    dispatch(setupMode('register'));
    dispatch(push(route));
};

export default switchToModeRegister;
