import {push} from 'connected-react-router';
import {
    ENTRY_REGISTER_ROUTE,
    ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_NEOPHONISH_PROCESS,
    ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_PROCESS,
    ENTRY_REGISTER_NEOPHONISH_PROCESS,
    ENTRY_REGISTER_PROCESS
} from '@blocks/UserEntryFlow/processes';
import {initWithPhoneConfirmation} from '@blocks/UserEntryFlow/logic';
import {setProcessError} from '@blocks/UserEntryFlow/actions';
import {getAdvancedError} from '@blocks/utils';
import {setRegisterMode} from '@blocks/SignUp/actions';
import {MODE_NEOPHONISH, MODE_WITH_SUGGEST_TO_RESTORE_BY_PHONE} from '@blocks/SignUp/modes/constants';
import {setupBackPane, setupPane} from '@blocks/common/actions';
import {setupMode} from '@blocks/authv2/actions/index';
import {isNeoPhonishRegisterAvailable} from '@blocks/selectors';
import {domikIsLoading} from '@blocks/auth/actions';
import api from '@blocks/api';

export const switchToModeRegisterWithPhone = (phone) => (dispatch, getState) => {
    const state = getState();
    const {router = {}, common = {}, signup = {}} = state;
    const {location = {}} = router;
    const {search} = location;
    const {pane} = common;
    const {config = {}} = signup;
    const {registerWithFullPersonalInfoOrigins = []} = config;
    const route = `${ENTRY_REGISTER_ROUTE}${search}`;
    const isNeoPhonishRegister = isNeoPhonishRegisterAvailable(state);

    dispatch(setRegisterMode(isNeoPhonishRegister ? MODE_NEOPHONISH : MODE_WITH_SUGGEST_TO_RESTORE_BY_PHONE));
    dispatch(setupBackPane(pane));
    dispatch(setupPane(route));
    dispatch(setupMode('register'));

    if (!phone) {
        dispatch(push(route));
        dispatch(domikIsLoading(false));
        return;
    }

    api.userEntryFlowSubmit()
        .then(() =>
            dispatch(
                initWithPhoneConfirmation({
                    phone,
                    route,
                    processName: registerWithFullPersonalInfoOrigins
                        ? isNeoPhonishRegister
                            ? ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_NEOPHONISH_PROCESS
                            : ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_PROCESS
                        : isNeoPhonishRegister
                        ? ENTRY_REGISTER_NEOPHONISH_PROCESS
                        : ENTRY_REGISTER_PROCESS
                })
            )
        )
        .catch(() => {
            dispatch(setProcessError(getAdvancedError('global', 'global')));
            dispatch(push(route));
        });
};
